# Bannerlord DLL Unlocker v1.0
# PowerShell version

# Check for administrator privileges
$isAdmin = ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)

if (-not $isAdmin) {
    Write-Host ""
    Write-Host "ERROR: This script requires administrator privileges." -ForegroundColor Red
    Write-Host "Right-click the script and select 'Run as Administrator'" -ForegroundColor Yellow
    Write-Host ""
    Read-Host "Press Enter to exit"
    exit 1
}

Write-Host ""
Write-Host "═══════════════════════════════════════" -ForegroundColor Green
Write-Host "  BANNERLORD DLL UNLOCKER v1.0" -ForegroundColor Green
Write-Host "═══════════════════════════════════════" -ForegroundColor Green
Write-Host ""

Write-Host "Searching for Mount and Blade II Bannerlord installation..." -ForegroundColor Cyan
Write-Host ""

$gamePath = $null
$found = $false

# Search in common installation paths
$searchPaths = @(
    'C:\Program Files (x86)\Steam\steamapps\common\Mount & Blade II Bannerlord',
    'C:\Program Files\Steam\steamapps\common\Mount & Blade II Bannerlord',
    'C:\Program Files\Epic Games\Mount & Blade II Bannerlord',
    'C:\Program Files\WindowsApps\TaleWorldsEntertainment.MountBladeIIBannerlord',
    'C:\Program Files (x86)\GOG Galaxy\Games\Mount & Blade II Bannerlord'
)

foreach ($path in $searchPaths) {
    if (Test-Path -LiteralPath $path) {
        $gamePath = $path
        $found = $true
        
        # Determine platform
        $platform = "Unknown"
        if ($path -like "*Steam*") { $platform = "Steam" }
        elseif ($path -like "*Epic*") { $platform = "Epic Games" }
        elseif ($path -like "*WindowsApps*") { $platform = "Microsoft Store" }
        elseif ($path -like "*GOG*") { $platform = "GOG" }
        
        Write-Host "[OK] Found on $platform" -ForegroundColor Green
        break
    }
}

# Try Steam registry as fallback
if (-not $found) {
    Write-Host "Checking Windows Registry..." -ForegroundColor Yellow
    try {
        $regPath = "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\Steam App 261550"
        if (Test-Path $regPath) {
            $installLocation = (Get-ItemProperty -Path $regPath -Name InstallLocation -ErrorAction Stop).InstallLocation
            if (Test-Path -LiteralPath $installLocation) {
                $gamePath = $installLocation
                $found = $true
                Write-Host "[OK] Found via Steam Registry" -ForegroundColor Green
            }
        }
    } catch {
        # Registry check failed, continue
    }
}

# Manual input if not found
if (-not $found) {
    Write-Host "[X] Could not automatically detect installation." -ForegroundColor Red
    Write-Host ""
    Write-Host "Please enter the path manually:" -ForegroundColor Yellow
    Write-Host "Example: C:\Program Files (x86)\Steam\steamapps\common\Mount & Blade II Bannerlord" -ForegroundColor Gray
    Write-Host ""
    $gamePath = Read-Host "Path"
    
    if (-not (Test-Path -LiteralPath $gamePath)) {
        Write-Host ""
        Write-Host "[ERROR] The specified path does not exist." -ForegroundColor Red
        Write-Host ""
        Read-Host "Press Enter to exit"
        exit 1
    }
}

Write-Host ""
Write-Host "═══════════════════════════════════════" -ForegroundColor Cyan
Write-Host "Unlocking DLL files..." -ForegroundColor Cyan
Write-Host "═══════════════════════════════════════" -ForegroundColor Cyan
Write-Host ""

$count = 0
$errors = 0

try {
    $dllFiles = Get-ChildItem -LiteralPath $gamePath -Recurse -Filter "*.dll" -ErrorAction SilentlyContinue
    
    foreach ($file in $dllFiles) {
        try {
            Unblock-File -LiteralPath $file.FullName -ErrorAction Stop
            $count++
            Write-Host "[OK]  " -ForegroundColor Green -NoNewline
            Write-Host $file.Name
        } catch {
            $errors++
            Write-Host "[SKIP] " -ForegroundColor Yellow -NoNewline
            Write-Host $file.Name
        }
    }
} catch {
    Write-Host ""
    Write-Host "Error during processing: $($_.Exception.Message)" -ForegroundColor Red
}

Write-Host ""
Write-Host "═══════════════════════════════════════" -ForegroundColor Cyan
Write-Host "Process completed!" -ForegroundColor Green
Write-Host "═══════════════════════════════════════" -ForegroundColor Cyan
Write-Host ""
Write-Host "Total files unlocked: $count" -ForegroundColor Cyan

if ($errors -gt 0) {
    Write-Host "Files skipped: $errors" -ForegroundColor Yellow
}

Write-Host ""
Write-Host "You can now launch the game normally." -ForegroundColor Green
Write-Host ""
Read-Host "Press Enter to exit"